import { View, Text, Pressable } from "react-native";
import React, { useEffect, useState } from "react";
import VariationContentStyle from "./VariationContent.style";
import { capitalized } from "../../../../../../../helper/capitalized";
import { useDispatch } from "react-redux";
import { variation } from "../../../../../../../redux/slices/featureProducts/items/itemVariations";

const SingleVariation = (props) => {
    const { item, variations, resetVariant } = props;
    const dispatch = useDispatch();
    const [selectedItemValue, setSelectedItemValue] = useState("");
    useEffect(() => {
        dispatch(variation({ key: item, value: selectedItemValue }));
    }, [selectedItemValue]);

    useEffect(() => {
        setSelectedItemValue("");
    }, [resetVariant]);

    const variationContentStyle = VariationContentStyle();
    return (
        <View>
            <Text style={variationContentStyle.variationTitle}>{`${capitalized(
                item
            )}:`}</Text>
            <View style={variationContentStyle.variationValueCont}>
                {variations[item]?.value?.map((value, index) => {
                    return (
                        <Pressable
                            key={index}
                            onPress={() => setSelectedItemValue(value)}
                        >
                            <Text
                                style={
                                    VariationContentStyle(
                                        value,
                                        selectedItemValue
                                    ).variationValueText
                                }
                            >
                                {value}
                            </Text>
                        </Pressable>
                    );
                })}
            </View>
        </View>
    );
};

export default SingleVariation;
